IF NOT EXISTS (SELECT * FROM SYS.TABLES WHERE NAME = 'GLB_EMAIL_ENV_RC_CLI')
BEGIN

    CREATE TABLE [dbo].[GLB_EMAIL_ENV_RC_CLI](
	    [CD_CTR] [int] NOT NULL,
	    [CD_EMP] [int] NOT NULL,
	    [CD_CLI] [int] NOT NULL,
	    [TP_DEST] [int] NOT NULL,
	CONSTRAINT [PK_GLB_EMAIL_ENV_RC_CLI] PRIMARY KEY CLUSTERED 
    (
	    [CD_CTR] ASC,
	    [CD_EMP] ASC,
	    [CD_CLI] ASC
    )WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
    ) ON [PRIMARY]

    ALTER TABLE [dbo].[GLB_EMAIL_ENV_RC_CLI]  WITH CHECK ADD  CONSTRAINT [FK_GLB_EMAIL_ENV_RC_CLI_GLB_EMAIL_ENV] FOREIGN KEY([CD_CTR])
    REFERENCES [dbo].[GLB_EMAIL_ENV] ([CD_CTR])

    ALTER TABLE [dbo].[GLB_EMAIL_ENV_RC_CLI] CHECK CONSTRAINT [FK_GLB_EMAIL_ENV_RC_CLI_GLB_EMAIL_ENV]

    ALTER TABLE [dbo].[GLB_EMAIL_ENV_RC_CLI]  WITH CHECK ADD  CONSTRAINT [FK_GLB_EMAIL_ENV_RC_CLI_RC_CLI] FOREIGN KEY([CD_EMP], [CD_CLI])
    REFERENCES [dbo].[RC_CLI] ([CD_EMP], [CD_CLI])

    ALTER TABLE [dbo].[GLB_EMAIL_ENV_RC_CLI] CHECK CONSTRAINT [FK_GLB_EMAIL_ENV_RC_CLI_RC_CLI]

END